<?php
require __DIR__ . "/db.php";

$contentType = strtolower($contentType);

if ($contentType === "" || strpos($contentType, "x-www-form-urlencoded") !== false) {
    // tentar tratar como raw / xml
}
$raw = file_get_contents("php://input");

// debug opcional (pode remover depois)
file_put_contents(__DIR__ . "/debug_payload.txt", $raw);

// ================= JSON =================
if (strpos($contentType, "application/json") !== false) {
    $data = json_decode($raw, true);

    if (!$data || !isset($data["uid"])) {
        http_response_code(400);
        echo json_encode(["error" => "invalid json or uid missing"]);
        exit;
    }

    $stmt = $pdo->prepare(
        "INSERT INTO characters (uid, data) VALUES (?, ?)"
    );
    $stmt->execute([
        $data["uid"],
        json_encode($data)
    ]);

    echo json_encode([
        "ok" => true,
        "id" => $pdo->lastInsertId()
    ]);
    exit;
}

// ================= XML =================
if (strpos($contentType, "xml") !== false) {
    $xml = simplexml_load_string($raw);

    if (!$xml || !isset($xml->uid)) {
        http_response_code(400);
        header("Content-Type: text/xml");
        echo "<response><error>invalid xml</error></response>";
        exit;
    }

    $stmt = $pdo->prepare(
        "INSERT INTO characters (uid, data) VALUES (?, ?)"
    );
    $stmt->execute([
        (string)$xml->uid,
        $raw
    ]);

    header("Content-Type: text/xml");
    echo "<response><ok>true</ok></response>";
    exit;
}

http_response_code(400);
echo "Unsupported format";
