<?php
require __DIR__ . "/db.php";
header("Content-Type: application/json");

$uid = $_GET["uid"] ?? null;

if (!$uid) {
    echo json_encode(["error" => "uid missing"]);
    exit;
}

// busca personagens do usuário
$stmt = $pdo->prepare(
    "SELECT id, data, created_at FROM characters WHERE uid = ?"
);
$stmt->execute([$uid]);

$characters = [];

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $characters[] = [
        "id" => $row["id"],
        "data" => json_decode($row["data"], true),
        "created_at" => $row["created_at"]
    ];
}

echo json_encode([
    "uid" => $uid,
    "username" => "TesteLocal",
    "characters" => $characters
]);
